<?php

namespace UtillzCore\Inc\Src;

class Forgery {

    use \UtillzCore\Inc\Src\Traits\Singleton;

    function __construct() {

        // forge components
        add_action( 'wp', [ $this, 'forgery' ] );
        add_action( 'elementor/editor/before_enqueue_scripts', [ $this, 'elementor_editor' ] );

        add_action( 'utillz/forge', [ $this, 'forge' ] );
        add_action( 'utillz/forge/listing', [ $this, 'forge_listing' ] );
        add_action( 'utillz/forge/submission', [ $this, 'forge_submission' ] );
        add_action( 'utillz/forge/explore', [ $this, 'forge_explore' ] );

    }

    public function elementor_editor() {
        do_action('utillz/forge/explore');
    }

    public function forgery() {
        do_action('utillz/forge');
    }

    public function forge() {
        if( ! is_admin() && ! wp_doing_ajax() ) {

            do_action('utillz/forge/explore');

            $post_type = get_post_type();

            if( $post_type == 'ulz_listing' ) {
                do_action('utillz/forge/listing');
            }elseif( $post_type == 'page' ) {
                if( get_option('ulz_page_submission') ) {
                    do_action('utillz/forge/submission');
                }
            }
        }
    }

    public function forge_listing() {
        Listing\Init::instance();
    }

    public function forge_submission() {
        Submission\Init::instance();
    }

    public function forge_explore() {
        global $ulz_explore;
        $ulz_explore = Explore\Explore::instance();
    }

}
